using System;
using System.Collections.Generic;
using System.Linq;

class BalancedTeam
{
    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        var a = Console.ReadLine().Split().Select(long.Parse).ToArray();
        
        var prefixSum = 0L;
        var prefixMap = new Dictionary<long, List<int>>();
        prefixMap[0] = new List<int> { -1 };
        int maxFrequency = 0;

        for (int i = 0; i < n; i++)
        {
            prefixSum += a[i];
            if (!prefixMap.ContainsKey(prefixSum))
                prefixMap[prefixSum] = new List<int>();
            prefixMap[prefixSum].Add(i);
        }

        foreach (var indices in prefixMap.Values)
        {
            if (indices.Count > 1)
            {
                var subarray = a.Skip(indices[0] + 1).Take(indices.Last() - indices[0]).ToArray();
                var freqCounter = subarray.GroupBy(x => x).ToDictionary(g => g.Key, g => g.Count());
                maxFrequency = Math.Max(maxFrequency, freqCounter.Values.Max());
            }
            else
            {
                maxFrequency = Math.Max(maxFrequency, 1);
            }
        }

        Console.WriteLine(maxFrequency);
    }
}